-- Create Hero Slider Table for Dynamic Content Management
CREATE TABLE IF NOT EXISTS `hero_slider` (
  `id` INT PRIMARY KEY AUTO_INCREMENT,
  `title` VARCHAR(255) NOT NULL,
  `description` TEXT NOT NULL,
  `badge` VARCHAR(100),
  `badge_icon` VARCHAR(100) DEFAULT 'fa-star',
  `button_1_text` VARCHAR(100),
  `button_1_url` VARCHAR(255),
  `button_1_type` VARCHAR(50) DEFAULT 'primary',
  `button_2_text` VARCHAR(100),
  `button_2_url` VARCHAR(255),
  `button_2_type` VARCHAR(50) DEFAULT 'secondary',
  `stat_1_number` INT,
  `stat_1_label` VARCHAR(100),
  `stat_2_number` INT,
  `stat_2_label` VARCHAR(100),
  `stat_3_number` INT,
  `stat_3_label` VARCHAR(100),
  `slide_bg_image` VARCHAR(255),
  `slide_hero_image` VARCHAR(255),
  `slide_order` INT DEFAULT 1,
  `is_active` TINYINT(1) DEFAULT 1,
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insert Sample Data
INSERT INTO `hero_slider` (`title`, `description`, `badge`, `badge_icon`, `button_1_text`, `button_1_url`, `button_1_type`, `button_2_text`, `button_2_url`, `button_2_type`, `stat_1_number`, `stat_1_label`, `stat_2_number`, `stat_2_label`, `stat_3_number`, `stat_3_label`, `slide_order`, `is_active`) VALUES
(
  'Professional Cleaning Services',
  'Experience the ultimate cleaning solutions with our expert team. We deliver spotless results and exceptional service for your home and business needs.',
  'Excellence in Service',
  'fa-check-circle',
  'Get Started',
  '/contact.php',
  'primary',
  'Learn More',
  '/service.php',
  'secondary',
  500,
  'Happy Clients',
  10,
  'Years Experience',
  98,
  'Satisfaction Rate',
  1,
  1
),
(
  'Eco-Friendly Cleaning Solutions',
  'Protect your environment while keeping spaces pristine. Our sustainable cleaning methods use eco-friendly products that are safe for your family and the planet.',
  'Green & Safe',
  'fa-leaf',
  'View Our Services',
  '/service.php',
  'primary',
  'Contact Us Today',
  '/contact.php',
  'secondary',
  1000,
  'Properties Cleaned',
  50,
  'Green Products Used',
  100,
  'Certified Team',
  2,
  1
);
